<?php

namespace App\Http\Controllers;

use App\Models\Doctor;
use App\Models\Service;
use Illuminate\Http\Request;

class HomeController extends Controller
{
    public function index()
    {
        $doctors = Doctor::where('is_active', true)->take(3)->get();
        $services = Service::where('is_active', true)->orderBy('sort_order')->take(6)->get();
        $testimonials = \App\Models\Testimonial::where('is_active', true)->orderBy('sort_order')->get();
        
        return view('home', compact('doctors', 'services', 'testimonials'));
    }
}
